clc;
close all;
%% Load Bronchiectasis patient lung sound file here
load Bronchiectasis_patient
Real_breath_sound_with_coarse_crackles    = data(1:end);
fs      = 44100;                                                                    %% Sampling frequency
time    = linspace(0,length(data)/fs,length(data));                                 %% Signal time duration
%% Plot
figure
plot(time,Real_breath_sound_with_coarse_crackles,'k');
xlabel('Time (s)','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
set(gcf, 'Position',  [100, 300, 800, 300])
title('Real breath sound with coarse crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');